#include <KMPDinoWiFiESP.h>
#include <KMPCommon.h>
#include <ESP8266WebServer.h>

const char WIFI_PSK[] = "1a2b3c4d";
const char SSID[] = "Charlie's Home";
const uint8_t PORT = 80;
ESP8266WebServer webServer(PORT);

void setup(void) {
  // initialize the PRODINo board
  KMPDinoWiFiESP.init();
  // setup the WiFi module as AccesPoint (AP Mode).
  WiFi.mode(WIFI_AP);
  // set the SSID and Password for the AP
  WiFi.softAP(SSID, WIFI_PSK);
  // set the HTTP route for the DHT22 sensor readings
  webServer.on("/opto", handleOptoRoute);
  // start the web server
  webServer.begin();
}

void loop(void) {
  webServer.handleClient();
}

void handleOptoRoute() {
  bool optoState;
  String result = "";
  // incomming GET request (get the state of all opto-inputs)
  if (webServer.method() == HTTP_GET) {
    for (uint8_t i = 0; i < 4; i++) {
      optoState = KMPDinoWiFiESP.GetOptoInState(i);
      result.concat("I_");
      result.concat(i);
      result.concat(" is ");
      result.concat(optoState == true ? "HIGH" : "LOW");
      result.concat("; ");
    }
    webServer.send(200, TEXT_HTML, result);
  } else {
    webServer.send(400, TEXT_HTML, "Bad request");
  }  
}
