package pl.model.converter;

import java.util.HashSet;
import java.util.Set;

import javax.persistence.AttributeConverter;
import javax.persistence.Converter;

import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;

import pl.model.LanguageEL;

@Converter
public class OtherAvailableLanguagesConverter implements
    AttributeConverter<Set<LanguageEL>, String> {

  @Override
  public String convertToDatabaseColumn( Set<LanguageEL> attrValue) {
    JSONArray jsonArr = new JSONArray( attrValue);
    return jsonArr.toString();
  }

  @Override
  public Set<LanguageEL> convertToEntityAttribute( String colValue) {
    Set<LanguageEL> result = new HashSet<LanguageEL>();
    try {
      JSONArray jsonArr = new JSONArray( colValue);
      for ( int i = 0, length = jsonArr.length(); i < length; i++) {
        result.add( LanguageEL.valueOf( jsonArr.getString( i)));
      }
    } catch ( JSONException e) {
      e.printStackTrace();
    }
    return result;
  }
}