package pl.model.converter;

import java.util.HashSet;
import java.util.Set;

import javax.persistence.AttributeConverter;
import javax.persistence.Converter;

import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;

import pl.model.PublicationFormEL;

@Converter
public class PublicationFormsConverter implements
    AttributeConverter<Set<PublicationFormEL>, String> {

  @Override
  public String convertToDatabaseColumn( Set<PublicationFormEL> attrValue) {
    JSONArray jsonArr = new JSONArray( attrValue);
    return jsonArr.toString();
  }

  @Override
  public Set<PublicationFormEL> convertToEntityAttribute( String colValue) {
    Set<PublicationFormEL> result = new HashSet<PublicationFormEL>();
    try {
      JSONArray jsonArr = new JSONArray( colValue);
      for ( int i = 0, length = jsonArr.length(); i < length; i++) {
        result.add( PublicationFormEL.valueOf( jsonArr.getString( i)));
      }
    } catch ( JSONException e) {
      e.printStackTrace();
    }
    return result;
  }
}