package pl.ctrl;

import javax.annotation.Resource;
import javax.faces.bean.ManagedBean;
import javax.faces.bean.SessionScoped;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;

import pl.model.Author;
import pl.model.Book;
import pl.model.Employee;
import pl.model.EmployeeTypeEL;
import pl.model.Person;
import pl.model.TextBook;

@SessionScoped @ManagedBean( name="appCtrl")
public class AppController {
  @PersistenceContext( unitName="SubtypingApp")
  private EntityManager em;
  @Resource private UserTransaction ut;

  /**
   * Clear/delete all entries from the database
   * 
   * @return a string representing the view name to display after finishing the
   *         execution of this method.
   * 
   * @throws NotSupportedException
   * @throws SystemException
   * @throws IllegalStateException
   * @throws SecurityException
   * @throws HeuristicMixedException
   * @throws HeuristicRollbackException
   * @throws RollbackException
   */
  public String clearData() {
    try {
      Book.clearData( em, ut);
      Person.clearData( em, ut);
    } catch ( Exception e) {
      e.printStackTrace();
    }
    return "index";
  }

  /**
   * Create test data (rows) in the database
   * 
   * @return a string representing the view name to display after finishing the
   *         execution of this method.
   * 
   * @throws NotSupportedException
   * @throws SystemException
   * @throws IllegalStateException
   * @throws SecurityException
   * @throws HeuristicMixedException
   * @throws HeuristicRollbackException
   * @throws RollbackException
   */
  public String createTestData() {
    try {
      this.clearData();
      Person p1, p2, p3, e1, e2;
      Book b1, b2, b3;
      ut.begin();
      p1 = new Author( 1, "Daniel Dennett", "First class author.");
      em.persist( p1);
      p2 = new Author( 2, "Douglas Hofstadter",
          "Wrote a lot of technical books.");
      em.persist( p2);
      p3 = new Author( 3, "Immanuel Kant",
          "One of the most influential philosophers of all time.");
      em.persist( p3);
      b1 = new TextBook( "006251587X", "Weaving the Web", 2000,
          "Web Programming");
      em.persist( b1);
      b2 = new Book( "0465026567", "Gdel, Escher, Bach", 1999);
      em.persist( b2);
      b3 = new TextBook( "0465030793", "I Am A Strange Loop", 2008,
          "Programming");
      em.persist( b3);
      e1 = new Employee( 4, "John Smith", 20178, null, null);
      em.persist( e1);
      e2 = new Employee( 5, "Tim Blank", 31237, EmployeeTypeEL.MANAGER,
          "Quality Check");
      em.persist( e2);
      ut.commit();
    } catch ( Exception e) {
      e.printStackTrace();
    }
    return "index";
  }
}